from neo4j.v1 import GraphDatabase, basic_auth
import csv
import sys

def extractPath(file):
	if '/' in file:
		path,filename = file.rsplit('/',1)
	else:
		path = ''
		filename = file
	return path,filename


def createOrGetFile(file,session):
	path,filename = extractPath(file)

	result = session.run("MATCH (f:file) WHERE f.name = '"+filename+"' and f.path='"+path+"' RETURN f;")
	results = list(result)
	resultNumber = len(results)
	#print("found "+str(resultNumber)+" corresponding elements")
	if resultNumber > 0:
		pass
	else:
		request = "CREATE(F:file {name:'"+filename+"', path: '"+path+"'});"
		session.run(request)
def createOrGetAuthor(authorName,session):
	path,filename = extractPath(file)

	result = session.run("MATCH (a:author) WHERE a.name = '"+authorName+"' RETURN a;")
	results = list(result)
	resultNumber = len(results)
	#print("found "+str(resultNumber)+" corresponding elements")
	if resultNumber > 0:
		pass
	else:
		request = "CREATE(a:author {name:'"+authorName+"'});"
		session.run(request)



def link(file1,author,session):
	file1Info = extractPath(file1)
	result = session.run("MATCH (f:file {name :'"+file1Info[1]+"', path:'"+file1Info[0]+"'}), (a:author {name :'"+author['author']+"'}),(c:component) WHERE (c)-[:CONTAINS]->(f) and (c)-[:OWNER_OF]->(a) return c")
	results = list(result)
	resultNumber = len(results)
	#print("found "+str(resultNumber)+" corresponding elements")
	if resultNumber > 0:
		print("found link")
	else:
		request = "MATCH (f:file {name :'"+file1Info[1]+"', path:'"+file1Info[0]+"'}), (a:author {name :'"+author['author']+"'}),(c:component) WHERE (c)-[:CONTAINS]->(f) create (c)-[:OWNER_OF{ownership:"+str(author['ownership'])+"}]->(a)"
		session.run(request)

driver = GraphDatabase.driver("bolt://localhost", auth=basic_auth("neo4j", "admin"))
session = driver.session()

files = {}
with open(sys.argv[1],'r') as datasource:
	reader = csv.reader(datasource,delimiter=',')
	i = 0
	for row in reader:
		if row[0].endswith('.java'):
			if i != 0:
				if row[0] not in files:
					files[row[0]] = {'lines':int(row[2])+int(row[3]), 'authors':[{'author':row[1],'lines':int(row[2])+int(row[3])}]}
				else:
					files[row[0]]['lines'] += int(row[2])+int(row[3])
					files[row[0]]['authors'].append({'author':row[1],'lines':int(row[2])+int(row[3])})
		i+=1
		# createOrGet(row[0],session)
		# createOrGet(row[1],session)
		# link(row[0],row[1],session)
for file in files:
	for author in files[file]['authors']:
		if files[file]['lines'] != 0:
			author['ownership'] = round(100* (author['lines']/files[file]['lines']))
		else:
			author['ownership'] = 0
i = 1
for file in files:
	print(str(i)+"/"+str(len(files)))
	print(int(i/len(files)*100)*"#")
	print(str(i/len(files) * 100)+"%")
	createOrGetFile(file,session)
	for author in files[file]['authors']:
		createOrGetAuthor(author['author'],session)
		#print("linking "+str(file)+" "+str(author))
		#print(author)
		if author['ownership'] > 50:
			link(file,author,session)
	i += 1