/*
 * The MIT License (MIT)
 * <p/>
 * Copyright (c) 2017
 * <p/>
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * <p/>
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * <p/>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package io.techcode.scrawler;

import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

import java.io.IOException;
import java.text.ParseException;
import java.util.Map;

/**
 * Abstract crawl implementation.
 */
public class ForumCrawler extends AbstractCrawler {

    ForumCrawler(String baseUri, Map<String, String> result) {
        super(baseUri, result);
    }

    @Override public void crawl() throws IOException, ParseException {
        Document doc = getConnection().get();
        TopicCrawler topicCrawler = new TopicCrawler("http://forum.terasology.org/", getResult());
        for (Element el : doc.body().select(".discussionListItems .main .titleText h3.title a")) {
            topicCrawler.setUri(el.attr("href"));
            getResult().put("forum", el.text());
            topicCrawler.crawl();
        }

        Element nextPage = doc.body().select(".PageNav nav > a:last-child").first();
        if (nextPage != null && nextPage.text().startsWith("Next")) {
            setUri(nextPage.attr("href"));
            crawl();
        }
    }

}
