#!/bin/python
import os
from neo4j.v1 import GraphDatabase, basic_auth
from glob import glob
import sys
print('walking '+sys.argv[1]+'/'+sys.argv[2])
result = [y for x in os.walk(sys.argv[1]+'/'+sys.argv[2]) for y in glob(os.path.join(x[0], 'src/'))]


def extractPath(file):
	if '/' in file:
		path,filename = file.rsplit('/',1)
	else:
		path = ''
		filename = file
	return path,filename



def createComponent(component,session):
	#path,filename = extractPath(file)

	result = session.run("MATCH (c:component) WHERE c.name = '"+component+"' RETURN c;")
	results = list(result)
	resultNumber = len(results)
	#print("found "+str(resultNumber)+" corresponding elements")
	if resultNumber > 0:
		pass
	else:
		request = "CREATE(c:component {name:'"+component+"'});"
		session.run(request)

def createAndLinkFile(file,component,session):
	path,filename = extractPath(file)

	result = session.run("MATCH (f:file) WHERE f.name = '"+filename+"' and f.path='"+path.split('/',1)[1]+"' RETURN f;")
	results = list(result)
	resultNumber = len(results)
	#print("found "+str(resultNumber)+" corresponding elements")
	if resultNumber > 0:
		pass
	else:
		request = "CREATE(F:file {name:'"+filename+"', path: '"+path.split('/',1)[1]+"'});"
		session.run(request)

	request = "MATCH(F:file {name:'"+filename+"', path: '"+path.split('/',1)[1]+"'}),(c:component {name:'"+component+"'}) CREATE (c)-[:CONTAINS]->(F)"
	#print(request)
	session.run(request)

def linkComponent(firstComponent,secondComponent,session):

	request = "MATCH (c1:component),(c2:component) where c1.name='"+firstComponent+"' and c2.name='"+secondComponent+"' CREATE (c1)-[:COMPONENT_OF]->(c2)"
	session.run(request)

driver = GraphDatabase.driver("bolt://localhost", auth=basic_auth("neo4j", "admin"))
session = driver.session()
baseComponent = sys.argv[2]
for component in result:
	internalC = False;
	componentName = str(component[len(sys.argv[1]):].rsplit('/',3)[1])
	if componentName == 'src' :
		componentName = str(component[len(sys.argv[1]):].rsplit('/',3)[0])
	if componentName != baseComponent:
		internalC = True
		print("is internalC")

	print("component is "+componentName)
	print('path '+component)
	createComponent(componentName,session)
	if internalC :
		linkComponent(componentName,baseComponent,session)
	files = [y for x in os.walk(component) for y in glob(os.path.join(x[0], '*.java'))]
	for file in files:
		#print(file[len(sys.argv[1])+1:])
		createAndLinkFile(file[len(sys.argv[1])+1:],componentName,session)

