# This script must run in the root folder of the scala git project.
# JiraReport.json nust be present too, it's the output of the first script.


#import requests
import json
import re
import subprocess as sub
import time




versions = [
#"Scala 2.10.0-M1",
# "Scala 2.10.0-M2",
## "Scala 2.10.0-M3",
# "Scala 2.10.0-M4",
# "Scala 2.10.0-M5", 
"Scala 2.10.0-M1"
]

sonarScannerCommand = "D:/logiciel/sonar/sonar-scanner-2.8/bin/sonar-scanner.bat"


pullRequests = []
#- load rimel1's json output
file = open("JiraReport.json")
content = file.read().replace('\n', '')
#print(content)
commits = json.loads(content)
#- iterate over versions
for j in range(len(versions)):
	bugs = commits[versions[j]]["issueByType"]["Bug"]
	#- iterate over bugs
	for i in range(len(bugs)):
		if bugs[i]["pull-request"] and "commits" in bugs[i].keys() and len(bugs[i]["commits"]) == 2:
			#- if pr and commits ok then gather the pullrequests
			pullRequest = {}
			pullRequest["version"] = versions[j]
			pullRequest["type"] = "Bug"
			pullRequest["key"] = bugs[i]["key"]
			pullRequest["commitMerge"] = bugs[i]["commits"][1]
			pullRequest["commitParent"] = bugs[i]["commits"][0]
			pullRequests.append(pullRequest)

print(json.dumps(pullRequests))
print("PRs gathered !")

#- iterae over PRs
for i in range(len(pullRequests)):
	#- override sonar properties to make the next analisys as new project
	fileProp = open("sonar-project.properties", "r+")
	contentProp = fileProp.read()
	#print(contentProp)
	projectKey = "org.scala:scala-%s-%s" % (i, pullRequests[i]["key"])
	projectName = "scala-%s-%s" % (i, pullRequests[i]["key"])
	projectVersion = "1.1.%s" % (pullRequests[i]["commitParent"])
	contentProp = re.sub("(sonar.projectKey=[^\n]*)", "sonar.projectKey=%s" % projectKey, contentProp)
	contentProp = re.sub("(sonar.projectName=[^\n]*)", "sonar.projectName=%s" % projectName, contentProp)
	contentProp = re.sub("(sonar.projectVersion=[^\n]*)", "sonar.projectVersion=%s" % projectVersion, contentProp)
	pullRequests[i]["projectKey"] = projectKey
	pullRequests[i]["projectName"] = projectName
	pullRequests[i]["projectVersionParent"] = projectVersion
	fileProp.seek(0)
	fileProp.write(contentProp)
	time.sleep(0.02)
	#- put scala project version on the right commit
	p = sub.Popen(['git', 'checkout', pullRequests[i]["commitParent"]],stdout=sub.PIPE,stderr=sub.PIPE)
	output, errors = p.communicate()
	print(output)
	print("git ok parent " + str(i))
	#- run scanner
	p = sub.Popen([sonarScannerCommand],stdout=sub.PIPE,stderr=sub.PIPE)
	output, errors = p.communicate()
	print(output)
	print("scanner ok parent " + str(i))
	time.sleep(120)

	#- override sonar properties to make the next analisys as new project version
	fileProp = open("sonar-project.properties", "r+")
	contentProp = fileProp.read()
	#print(contentProp)
	projectVersion = "1.2.%s" % (pullRequests[i]["commitMerge"])
	contentProp = re.sub("(sonar.projectVersion=[^\n]*)", "sonar.projectVersion=%s" % projectVersion, contentProp)
	pullRequests[i]["projectVersionMerge"] = projectVersion
	fileProp.seek(0)
	fileProp.write(contentProp)
	time.sleep(0.02)
	#- put scala project version on the right commit
	p = sub.Popen(['git', 'checkout', pullRequests[i]["commitMerge"]],stdout=sub.PIPE,stderr=sub.PIPE)
	output, errors = p.communicate()
	print(output)
	print("git ok merge " + str(i))
	#- run scanner
	p = sub.Popen([sonarScannerCommand],stdout=sub.PIPE,stderr=sub.PIPE)
	output, errors = p.communicate()
	print(output)
	print("scanner ok merge " + str(i))
	time.sleep(120)

fileOut = open("scannedPR.json", "r+")
fileOut.seek(0)
fileOut.write(json.dumps(pullRequests))
fileOut.close()
time.sleep(0.02)

# sonar creer un projet par pull request et faire deux versions
# faire deux boucle une pour creer un projet l'autre pour faire le second commit

print("scanner done on each pr !")
