# This script must run in the root folder of the scala git project.
# scannedPR.json nust be present too, it's the output of the second script.
# pip install requests 

import requests
import json
import re
import subprocess as sub
import time


sonarSearchIssueURI = "http://localhost:9000/api/issues/search"
sonarOpenTotURI = sonarSearchIssueURI + "?statuses=OPEN&componentKeys="
sonarOpenURI = sonarSearchIssueURI + "?statuses=OPEN&sinceLeakPeriod=true&componentKeys="
sonarClosedURI = sonarSearchIssueURI + "?statuses=CONFIRMED,REOPENED,RESOLVED,CLOSED&sinceLeakPeriod=true&componentKeys="
severtitiesOption = "&severities="
headersSonar = {}
severities = [
"INFO",
"MINOR",
"MAJOR",
"CRITICAL",
"BLOCKER"]





pullRequests = []
#- load djoe's json
file = open("scannedPR.json")
content = file.read().replace('\n', '')
#print(content)
pullRequests = json.loads(content)
#pullRequest = {}
#pullRequest["key"] = "test-2"
#pullRequest["version"] = "truc M2"
#pullRequest["type"] = "Bug"
#pullRequest["projectKey"] = "org.scala:scala-test-2"
#pullRequests.append(pullRequest)
#pullRequest1 = {}
#pullRequest1["key"] = "test-1"
#pullRequest1["version"] = "truc M3"
#pullRequest1["type"] = "autre"
#pullRequest1["projectKey"] = "org.scala:scala-test-2"
#pullRequests.append(pullRequest1)
print(json.dumps(pullRequests))

for i in range(len(pullRequests)):
	openTotURI = sonarOpenTotURI + pullRequests[i]["projectKey"]
	openURI = sonarOpenURI + pullRequests[i]["projectKey"]
	closedURI = sonarClosedURI + pullRequests[i]["projectKey"]

	for j in range(len(severities)):
		pullRequests[i][severities[j]] = {}

		URI = openTotURI + severtitiesOption + severities[j]
		issuesTot = json.loads(requests.get(URI, headers=headersSonar).text)
		pullRequests[i][severities[j]]["total"] = issuesTot["total"]

		URI = openURI + severtitiesOption + severities[j]
		issuesAdded = json.loads(requests.get(URI, headers=headersSonar).text)
		pullRequests[i][severities[j]]["added"] = issuesAdded["total"]

		URI = closedURI + severtitiesOption + severities[j]
		issuesRemoved = json.loads(requests.get(URI, headers=headersSonar).text)
		pullRequests[i][severities[j]]["removed"] = issuesRemoved["total"]

# write full data as json
time.sleep(0.02)
fileOut = open("PRtocsv.json", "r+")
fileOut.seek(0)
fileOut.write(json.dumps(pullRequests))
fileOut.close()
time.sleep(0.02)


# build csv
csvContent = "key,version,type,severity,total,added,removed"

for i in range(len(pullRequests)):
	for j in range(len(severities)):
		csvContent = csvContent + "\n" + pullRequests[i]["key"] + ","
		csvContent = csvContent + pullRequests[i]["version"] + ","
		csvContent = csvContent + pullRequests[i]["type"] + ","
		csvContent = csvContent + severities[j] + ","
		csvContent = csvContent + str(pullRequests[i][severities[j]]["total"]) + ","
		csvContent = csvContent + str(pullRequests[i][severities[j]]["added"]) + ","
		csvContent = csvContent + str(pullRequests[i][severities[j]]["removed"])


#write csv
time.sleep(0.02)
fileOut = open("output.csv", "r+")
fileOut.seek(0)
fileOut.write(csvContent)
fileOut.close()
time.sleep(0.02)

