import requests
import json
import re

headers1 = {'Authorization': 'token 254251e3af93a8523830c92c58e2a17572f49176'}
jiraVersionsQuery = "https://issues.scala-lang.org/rest/api/2/project/SI/versions?jql=released=True"
jiraVersionQuery = "https://issues.scala-lang.org/rest/api/2/search?jql=project %3D SI AND affectedVersion="
ticketQuery = "https://issues.scala-lang.org/rest/api/2/issue/"
commitQuery = "https://api.github.com/repos/scala/scala/commits/"
releases = ["2.10.", "2.11.", "2.12.", "2.13."]
branches = {"2.10." : "2.10.x", "2.11." : "2.11.x", "2.12." : "2.12.x", "2.13." : "2.13.x"}
githubBranche = "https://api.github.com/repos/scala/scala/commits?per_page=100&sha=d56d66d9f0cdb7a7241d0f876aba2786cd18d1f5"


commitsRecap = {} 

if len(commitsRecap) == 0:
	for i in range(1,300):
		commits = {}
		try:
			commits = json.loads(requests.get(githubBranche + "&page=" + str(i), headers=headers1).text)
		except:
			break
		
		
		for commit in commits:
			message = commit["commit"]["message"]
			sha = commit["sha"]
			key = ""
			parent = ""
			
			p = re.compile('Merge pull')
			if len(p.findall(message)) != 0:
				p = re.compile('#\d+')
				matches = p.findall(message);
				
				if len(matches) > 0:
					key = matches[0][1:]
					parent = commit["parents"][0]["sha"]
			else:
				p = re.compile('SI\-\d+')
				matches = p.findall(message);		
				if len(matches) > 0:
					key = matches[0]

			if key != "":
				if key not in commitsRecap:
					commitsRecap[key] = []
				
				commitsRecap[key].append(sha)
				
				if parent != "":
					commitsRecap[key].append(parent)
print(commitsRecap)

response = requests.get(jiraVersionsQuery)

versions = json.loads(response.text)


recap = {}

for i in range(len(versions)):
	if not any(r in versions[i]["name"] for r in releases):
		continue;
	
	release = "";
	for r in releases:
		if r in versions[i]["name"]:
			release = r
			
	githubBranche = branches[release];
	
	
	tickets = {}
	try:
		tickets = json.loads(requests.get(jiraVersionQuery + "\"" + versions[i]["name"] + "\"&maxResults=500").text)
	except:
		tickets = json.loads(requests.get(jiraVersionQuery + "\"" + versions[i]["name"] + "\"&maxResults=500").text)
	
	versionRecap = {}
	
	recap[versions[i]["name"]] = versionRecap
	
	versionRecap["total"] = tickets["total"]
	tickets = tickets["issues"]
	
	versionRecap["Bug"] = 0
	versionRecap["New Feature"] = 0
	versionRecap["Improvement"] = 0
	
	versionRecap["issueByType"] = {"Bug":[], "New Feature" : [], "Improvement" : []}
	
		
	print(versions[i]["name"] + " : " +str(len(tickets)))
	for j in range(len(tickets)):
		issue = tickets[j]
		key = issue["key"]
		id = issue["id"]
		fields = issue["fields"]
		issuetype = fields["issuetype"]["name"]
		labels = fields["labels"]
		pullRequest = False
		ignore = False
		
		if "has-pull-request" in labels:
			temp = {}
			try:
				temp = json.loads(requests.get(ticketQuery + str(id)).text)
			except:
				temp = json.loads(requests.get(ticketQuery + str(id)).text)
			for c in temp["fields"]["comment"]["comments"]:
				comment = c["body"]
				key = comment
				try:
					key = re.search("(?P<url>https?://git[^\s]+)", key).group("url")
					keyPart = key.split('/')
					if keyPart[-2] == "pull":
						key = key.split('/')[-1]
						
						p = re.compile('\d+')
						key = p.findall(key)[0]		
						
						ignore = False
						break
					else:
						ignore = True
				except:
					ignore = True
			pullRequest = True
		versionRecap[issuetype] += 1
		
		if not ignore:			
			ticketRecap = {"key": key, "pull-request" : pullRequest}
			if key in commitsRecap:
				ticketRecap[ "commits" ] = commitsRecap[key]
			versionRecap["issueByType"][issuetype].append(ticketRecap)
		
	
print(json.dumps(recap))
	

		
		