# make sure ES is up and running
# import requests
# res = requests.get('http://localhost:9200')
# print(res.content)

#connect to our cluster
# from elasticsearch import Elasticsearch
# es = Elasticsearch([{'host': 'localhost', 'port': 9200}])


from datetime import datetime
from elasticsearch import Elasticsearch

es = Elasticsearch()

es.indices.create(
    index='git-log1',
    body={
        'mappings': {
            'git_log': {
                'properties': {
                    'author': {'type': 'keyword'},
                    'message': {'type': 'text'},
                    'label': {'type': 'keyword'},
                    'timestamp': {'type': 'date'}
                }
            }
        }
    }
)

def labelProcess(p_msg) :
	l_parse = p_msg.split( )
	for c_word in l_parse :
		if c_word.lower() == "fix" :
			return "fix bug"
		elif (c_word.lower() == "docs") | (c_word.lower() == "doc") | (c_word.lower() == "documentation") :
			return "documentation"
	return "other"

# git log --pretty="%an - %ad - %s" --date=short
with open('../data/git_log_2.txt') as c_fp:
	l_id = 1
	for c_line in c_fp :
		l_line = c_line.split(":$:")
		l_date = datetime.strptime(l_line[1], "%Y-%m-%d")
		l_doc = {
			'author': l_line[0],
			'message': l_line[2],
			'label': labelProcess(l_line[2]),
			'timestamp': l_date
		}
		l_res = es.index(index="git-log1", doc_type='git_log', id=l_id, body=l_doc)
		l_id += 1
		#print(res['created'])