#!/usr/bin/env python
# -*- coding: utf-8 -*-
# author: mahdiall - Fev 2017

import re, sys, os, time as time_

inputFile = ""
outputFile = ""
fileTypes = ""
totalCommit = 0
commitRegex = r"^(--|\[)(.)+"
fileRegex = r"(.)+\."
dateRegex = r"(\d{4})[/.-](\d{2})[/.-](\d{2})"
listFile = []
numberOfCommits = 0
constraints = ""

if len(sys.argv) == 5:
	inputFile = sys.argv[1]
	outputFile = sys.argv[2]
	fileTypes = sys.argv[3].replace(',', '|')
	constraints = sys.argv[4]
	fileRegex += "(" + fileTypes + ")$" 
	listFile = fileTypes.split('|')
else:
	print "\npython ./parser.py <input_file> <output_file> file-types (any|all)"
	print "\tfile-types separated by ','\n"
	sys.exit(os.EX_SOFTWARE)

def millis():
	return str(int(round(time_.time()*1000)))

def writeToFile(out_file, commit, files):
	out_file.write(commit)
	out_file.write(files)
	out_file.write('\n')
	print "\t\tcommit-NUMBER: ", numberOfCommits,", commit-details:", commit, " processed!"

try:
	commit = ""
	files = ""
	in_file = open(inputFile, 'r')
	out_file = open(outputFile, 'w+')
	#commit_file = open("_commit_" + millis() + ".log", 'w+')	
	print "\n\t*** Processing" + inputFile + " ..." 
	for line in in_file.readlines():
		matchedCommit = re.match(commitRegex, line.strip())
		matchedFile = re.match(fileRegex, line.strip())
		if(matchedCommit != None):
			commit = line
			totalCommit += 1
		if(matchedFile != None):
			files += line
		if (line == '\n'):
			if(files != ""):
				if(constraints == "any"):
					if any(x in files for x in listFile):
						writeToFile(out_file, commit, files)
						numberOfCommits+=1
				elif(constraints == "all"):
					if all(x in files for x in listFile):
					   writeToFile(out_file, commit, files)
					   numberOfCommits+=1
				else:
					sys.exit(os.EX_SOFTWARE)
				commit = ""
				files = ""
			else:
				commit = ""
	print "\n\t*** Total found: ", numberOfCommits, " !"
	print "\n\t*** % ", round((numberOfCommits*100.0)/totalCommit, 2), " commit with ", listFile 
	print "\n\t*** Total commits: ", totalCommit, " !"
	print "\n\t*** End process!\n"
finally:
	in_file.close()
	out_file.close()

